<?php
require_once '../config/db.php';
// جلب الإعدادات
$settings = [];
$stmt = $pdo->query('SELECT key_name, value FROM settings');
foreach ($stmt as $row) {
    $settings[$row['key_name']] = $row['value'];
}
// تصفية المشاريع حسب الحالة
$status = $_GET['status'] ?? '';
if ($status && in_array($status, ['مكتمل','تحت الانشاء','تم البيع'])) {
    $projects = $pdo->prepare('SELECT * FROM projects WHERE status = ? ORDER BY id DESC');
    $projects->execute([$status]);
    $projects = $projects->fetchAll();
} else {
    $projects = $pdo->query('SELECT * FROM projects ORDER BY id DESC')->fetchAll();
}
?>
<!DOCTYPE html>
<html lang="ar">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>جميع المشاريع</title>
    <link rel="stylesheet" href="../public/style.css">
    <style>
        body { background: <?= $settings['bg_color'] ?? '#EEEEEE' ?>; font-family: 'Cairo', sans-serif; }
        .navbar { background: <?= $settings['main_color'] ?? '#EA9218' ?>; color: #fff; padding: 12px 0; display: flex; align-items: center; justify-content: space-between; }
        .navbar img { height: 48px; margin-right: 16px; }
        .navbar ul { list-style: none; display: flex; gap: 24px; margin: 0; padding: 0; }
        .navbar li { display: inline; }
        .navbar a { color: #fff; text-decoration: none; font-weight: bold; font-size: 18px; }
        .projects-title { color: <?= $settings['main_color'] ?? '#EA9218' ?>; font-size: 28px; margin: 32px 0 24px; text-align: center; }
        .filter-bar { text-align: center; margin-bottom: 24px; }
        .filter-btn { background: #EA9218; color: #fff; border: none; padding: 8px 24px; border-radius: 4px; margin: 0 8px; font-size: 16px; cursor: pointer; }
        .project-cards { display: flex; flex-wrap: wrap; gap: 24px; justify-content: center; }
        .project-card { background: #fff; border-radius: 8px; box-shadow: 0 0 8px #31384122; padding: 16px; min-width: 220px; max-width: 300px; text-align: center; position: relative; margin-bottom: 24px; }
        .project-card .status { position: absolute; top: 8px; left: 8px; background: <?= $settings['main_color'] ?? '#EA9218' ?>; color: #fff; padding: 4px 12px; border-radius: 6px; font-size: 14px; }
        .project-card h3 { color: <?= $settings['secondary_color'] ?? '#3A4750' ?>; margin-bottom: 8px; }
        .project-card .location { color: <?= $settings['text_color'] ?? '#313841' ?>; font-size: 15px; margin-bottom: 8px; }
        .project-card .units { color: #EA9218; font-size: 14px; margin-bottom: 8px; }
        .project-card .price { color: #3A4750; font-size: 16px; margin-bottom: 8px; }
        .project-card .actions { margin-top: 12px; display: flex; gap: 8px; justify-content: center; }
        .project-card .btn { background: #EA9218; color: #fff; border: none; padding: 6px 16px; border-radius: 4px; cursor: pointer; font-size: 14px; text-decoration: none; }
        .footer { background: <?= $settings['secondary_color'] ?? '#3A4750' ?>; color: #fff; padding: 24px 0; text-align: center; margin-top: 48px; }
        .footer img { height: 40px; margin-bottom: 8px; }
    </style>
</head>
<body>
    <!-- النافبار -->
    <nav class="navbar">
        <div>
            <img src="../assets/<?= htmlspecialchars($settings['logo'] ?? 'logo.png') ?>" alt="شعار الشركة">
        </div>
        <ul>
            <li><a href="index.php">الرئيسية</a></li>
            <li><a href="projects.php">المشاريع</a></li>
            <li><a href="about.php">من نحن</a></li>
            <li><a href="contact.php">تواصل معنا</a></li>
            <li><a href="#" onclick="alert('قريباً!');">تغيير اللغة</a></li>
        </ul>
    </nav>
    <div class="projects-title">جميع المشاريع</div>
    <div class="filter-bar">
        <a href="projects.php" class="filter-btn">الكل</a>
        <a href="projects.php?status=مكتمل" class="filter-btn">مكتمل</a>
        <a href="projects.php?status=تحت الانشاء" class="filter-btn">تحت الإنشاء</a>
        <a href="projects.php?status=تم البيع" class="filter-btn">تم البيع</a>
    </div>
    <div class="project-cards">
        <?php foreach ($projects as $project): ?>
        <div class="project-card">
            <div class="status"> <?= $project['status'] ?> </div>
            <h3><?= htmlspecialchars($project['name']) ?></h3>
            <div class="location"> <?= htmlspecialchars($project['location']) ?> </div>
            <div class="units">عدد الوحدات: <?= $project['units_count'] ?> </div>
            <div class="price">السعر: <?= $project['price_from'] ?> - <?= $project['price_to'] ?> ريال</div>
            <div class="actions">
                <a class="btn" href="project_details.php?id=<?= $project['id'] ?>">تفاصيل المشروع</a>
                <?php if (!empty($project['brochure'])): ?>
                    <a class="btn" href="../uploads/<?= htmlspecialchars($project['brochure']) ?>" target="_blank">تحميل الكتيب</a>
                <?php endif; ?>
            </div>
        </div>
        <?php endforeach; ?>
    </div>
    <!-- الفوتر -->
    <footer class="footer">
        <?php if (!empty($settings['logo'])): ?>
            <img src="../assets/<?= htmlspecialchars($settings['logo']) ?>" alt="شعار الشركة">
        <?php endif; ?>
        <div><?= htmlspecialchars($settings['company_name'] ?? 'شركتنا العقارية') ?></div>
        <div>جميع الحقوق محفوظة &copy; <?= date('Y') ?></div>
    </footer>
</body>
</html>
